/*
 * Decompiled with CFR 0.152.
 */
package com.yurtmod.item;

import com.yurtmod.block.TileEntityTentDoor;
import com.yurtmod.dimension.TentDimension;
import com.yurtmod.init.Config;
import com.yurtmod.init.NomadicTents;
import com.yurtmod.init.TentSaveData;
import com.yurtmod.structure.StructureBase;
import com.yurtmod.structure.StructureType;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemTent
extends Item {
    public static final int ERROR_TAG = Short.MIN_VALUE;
    public static final String OFFSET_X = "TentOffsetX";
    public static final String OFFSET_Z = "TentOffsetZ";

    public ItemTent() {
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77637_a(NomadicTents.TAB);
    }

    public void func_77622_d(ItemStack itemStack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            if (itemStack.func_77978_p() == null) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            this.adjustSaveData(itemStack, world, player);
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int i0, boolean b0) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!stack.func_77978_p().func_74764_b(OFFSET_X)) {
            stack.func_77978_p().func_74768_a(OFFSET_X, Short.MIN_VALUE);
        }
        if (!stack.func_77978_p().func_74764_b(OFFSET_Z)) {
            stack.func_77978_p().func_74768_a(OFFSET_Z, Short.MIN_VALUE);
        }
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World worldIn, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (!TentDimension.isTentDimension(worldIn)) {
            BlockPos hitPos = pos;
            Block hitBlock = worldIn.func_180495_p(pos).func_177230_c();
            ItemStack stack = player.func_184586_b(hand);
            EnumFacing hitSide = side;
            if (hitBlock == null || stack == null || stack.func_190926_b()) {
                return EnumActionResult.FAIL;
            }
            if (ItemTent.hasInvalidCoords(stack)) {
                if (worldIn.field_72995_K) {
                    TextComponentTranslation lines = new TextComponentTranslation(TextFormatting.WHITE + "----------------------------", new Object[0]);
                    player.func_145747_a((ITextComponent)lines);
                    player.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.RED + I18n.func_135052_a((String)"chat.no_structure_ln1", (Object[])new Object[0]), new Object[0]));
                    player.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.RED + I18n.func_135052_a((String)"chat.no_structure_ln2", (Object[])new Object[0]), new Object[0]));
                    player.func_145747_a((ITextComponent)lines);
                }
                if (Config.ALLOW_REFUND) {
                    ItemTent.dropComponents(worldIn, player, stack);
                    stack.func_190920_e(stack.func_190916_E() - 1);
                }
                return EnumActionResult.FAIL;
            }
            if (StructureBase.REPLACE_BLOCK_PRED.test(worldIn.func_180495_p(hitPos))) {
                hitPos = hitPos.func_177979_c(1);
                hitSide = EnumFacing.UP;
            } else {
                hitPos = hitPos.func_177981_b(1);
            }
            if (!player.func_175151_a(hitPos, hitSide, stack)) {
                return EnumActionResult.FAIL;
            }
            if (hitSide.equals((Object)EnumFacing.UP)) {
                int meta = stack.func_77952_i();
                EnumFacing playerFacing = player.func_174811_aO();
                StructureType type = StructureType.get(meta);
                StructureBase struct = type.getNewStructure();
                if (struct.canSpawn(worldIn, hitPos, playerFacing, StructureType.Size.SMALL) && struct.generateFrameStructure(worldIn, hitPos, playerFacing, StructureType.Size.SMALL)) {
                    TileEntity te = worldIn.func_175625_s(hitPos);
                    if (te != null && te instanceof TileEntityTentDoor) {
                        StructureType.applyToTileEntity(player, stack, (TileEntityTentDoor)te);
                    } else {
                        System.out.println("[ItemTent] Error! Failed to retrieve TileEntityTentDoor at " + hitPos);
                    }
                    stack.func_190920_e(stack.func_190916_E() - 1);
                }
            }
        }
        return EnumActionResult.PASS;
    }

    public boolean func_82788_x() {
        return true;
    }

    public String func_77667_c(ItemStack stack) {
        return "item." + StructureType.getName(stack);
    }

    public void func_150895_a(Item itemIn, CreativeTabs tab, NonNullList<ItemStack> subItems) {
        for (StructureType type : StructureType.values()) {
            ItemStack tent = type.getDropStack(Short.MIN_VALUE, Short.MIN_VALUE);
            subItems.add((Object)tent);
        }
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return Integer.MAX_VALUE;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List par3List, boolean par4) {
        TextFormatting color = StructureType.get(stack.func_77952_i()).getTooltipColor();
        par3List.add(color + I18n.func_135052_a((String)"tooltip.extra_dimensional_space", (Object[])new Object[0]));
    }

    public static boolean hasInvalidCoords(ItemStack stack) {
        if (stack.func_77978_p() != null) {
            return stack.func_77978_p().func_74762_e(OFFSET_X) == Short.MIN_VALUE && stack.func_77978_p().func_74762_e(OFFSET_Z) == Short.MIN_VALUE;
        }
        return true;
    }

    public static void dropComponents(World world, EntityPlayer player, ItemStack stack) {
        List list = CraftingManager.func_77594_a().func_77592_b();
        for (IRecipe r : list) {
            ItemStack output = r.func_77571_b();
            if (!(r instanceof ShapedRecipes) || !stack.func_77969_a(output)) continue;
            ShapedRecipes sr = (ShapedRecipes)r;
            ItemStack[] in = sr.field_77574_d;
            if (in.length <= 0) continue;
            for (ItemStack i : in) {
                if (i == null || i.func_77973_b() == null) continue;
                EntityItem toSpawn = new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, i);
                toSpawn.func_174868_q();
                if (world.field_72995_K) continue;
                world.func_72838_d((Entity)toSpawn);
            }
        }
    }

    public void adjustSaveData(ItemStack stack, World world, EntityPlayer player) {
        TentSaveData data = TentSaveData.forWorld(world);
        StructureType struct = StructureType.get(stack.func_77952_i());
        stack.func_77978_p().func_74768_a(OFFSET_Z, struct.getTagOffsetZ());
        switch (struct) {
            case TEPEE_LARGE: {
                data.addCountTepeeLarge(1);
                data.addCountTepeeMed(-1);
                stack.func_77978_p().func_74768_a(OFFSET_X, data.getCountTepeeLarge());
                break;
            }
            case TEPEE_MEDIUM: {
                data.addCountTepeeMed(1);
                data.addCountTepeeSmall(-1);
                stack.func_77978_p().func_74768_a(OFFSET_X, data.getCountTepeeMed());
                break;
            }
            case TEPEE_SMALL: {
                data.addCountTepeeSmall(1);
                stack.func_77978_p().func_74768_a(OFFSET_X, data.getCountTepeeSmall());
                break;
            }
            case YURT_LARGE: {
                data.addCountYurtLarge(1);
                data.addCountYurtMed(-1);
                stack.func_77978_p().func_74768_a(OFFSET_X, data.getCountYurtLarge());
                break;
            }
            case YURT_MEDIUM: {
                data.addCountYurtMed(1);
                data.addCountYurtSmall(-1);
                stack.func_77978_p().func_74768_a(OFFSET_X, data.getCountYurtMed());
                break;
            }
            case YURT_SMALL: {
                data.addCountYurtSmall(1);
                stack.func_77978_p().func_74768_a(OFFSET_X, data.getCountYurtSmall());
                break;
            }
            case BEDOUIN_LARGE: {
                data.addCountBedouinLarge(1);
                data.addCountBedouinMed(-1);
                stack.func_77978_p().func_74768_a(OFFSET_X, data.getCountBedouinLarge());
                break;
            }
            case BEDOUIN_MEDIUM: {
                data.addCountBedouinMed(1);
                data.addCountBedouinSmall(-1);
                stack.func_77978_p().func_74768_a(OFFSET_X, data.getCountBedouinMed());
                break;
            }
            case BEDOUIN_SMALL: {
                data.addCountBedouinSmall(1);
                stack.func_77978_p().func_74768_a(OFFSET_X, data.getCountBedouinSmall());
            }
        }
    }
}

